package jamezo97.clonecraft.dna;

import net.minecraft.entity.CloneCraftEntityAccessor;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityWither;
import net.minecraft.entity.monster.EntityGiantZombie;

public class GeneLarge extends Gene {

	public GeneLarge(int id) {
		super(id);
	}

	@Override
	public String getName() {
		return "Large";
	}

	@Override
	public int getMaxAmount() {
		return 2;
	}

	@Override
	public String getStringValue(int amount) {
		return amount + "x Size Enlargement";
	}

	@Override
	public int getColour() {
		return 0xff3465dd;
	}

	@Override
	public Class[] getEntityClassesWithGene() {
		return new Class[]{
				EntityGiantZombie.class, EntityDragon.class, EntityWither.class	
		}; 
	}

	@Override
	public void onUpdate(EntityLivingBase entity, IModifiable mod, int level) {
		float scale = level;
		if(mod.hasGene(Gene.small)){
			scale = scale / ((float)mod.getGeneStrength(Gene.small));
		}
		mod.setGeneScaling(scale);

		float width = mod.getBaseXSize();
		float height = mod.getBaseYSize();
		float yOffset = mod.getBaseYOffset();
		
		if(mod.shouldApplySizeChange()){
			width *= scale;
			height *= scale;
			yOffset *= scale;
			entity.stepHeight = mod.getBaseStepHeight() * scale;
		}
//		
//		entity.yOffset = yOffset;
		
		if(entity.width != width || entity.height != height){
			CloneCraftEntityAccessor.setSize(entity, width, height);
		}
	}

	@Override
	public void addGeneEffect(EntityLivingBase entity, int level) {
	}

}
